/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestDeserializationContext;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface IQuestFactory<D extends IQuestData, Q extends Quest<D>> {
    public Q makeQuestInstance(QuestScheme<D> var1, UUID var2);

    public Q questFromContext(QuestDeserializationContext<D> var1);

    public static <D extends IQuestData, Q extends Quest<D>> IQuestFactory<D, Q> of(final BiFunction<QuestScheme<D>, UUID, Q> instanceFactory, final Function<QuestDeserializationContext<D>, Q> deserializer) {
        return new IQuestFactory<D, Q>(){

            @Override
            public Q makeQuestInstance(QuestScheme<D> scheme, UUID traderId) {
                return (Quest)instanceFactory.apply(scheme, traderId);
            }

            @Override
            public Q questFromContext(QuestDeserializationContext<D> context) {
                return (Quest)deserializer.apply(context);
            }
        };
    }
}

